<?php

declare(strict_types=1);

namespace Siel\AcumulusCustomiseInvoice\Observer;

use Magento\Framework\Event\Observer as EventObserver;
use Magento\Framework\Event\ObserverInterface;
use Siel\AcumulusCustomiseInvoice\Helper\AcumulusCustomiseInvoice;

/**
 * Siel Acumulus line collect after observer.
 */
class AcumulusLineCollectAfter implements ObserverInterface
{
    private AcumulusCustomiseInvoice $handler;

    public function __construct(AcumulusCustomiseInvoice $acumulusEventHandler)
    {
        $this->handler = $acumulusEventHandler;
    }

    public function execute(EventObserver $observer): void
    {
        $this->handler->lineCollectAfter(
            $observer->getDataByKey('line'),
            $observer->getDataByKey('propertySources')
        );
    }
}
