<?php

declare(strict_types=1);

namespace Siel\AcumulusCustomiseInvoice\Observer;

use Magento\Framework\Event\Observer as EventObserver;
use Magento\Framework\Event\ObserverInterface;
use Siel\AcumulusCustomiseInvoice\Helper\AcumulusCustomiseInvoice;

/**
 * Siel Acumulus invoice send before observer.
 */
class AcumulusInvoiceSendBefore implements ObserverInterface
{
    private AcumulusCustomiseInvoice $handler;

    public function __construct(AcumulusCustomiseInvoice $acumulusEventHandler)
    {
        $this->handler = $acumulusEventHandler;
    }

    public function execute(EventObserver $observer): void
    {
        $this->handler->invoiceSendBefore(
            $observer->getDataByKey('invoice'),
            $observer->getDataByKey('localResult')
        );
    }
}
