<?php

declare(strict_types=1);

namespace Siel\AcumulusCustomiseInvoice\Observer;

use Magento\Framework\Event\Observer as EventObserver;
use Magento\Framework\Event\ObserverInterface;
use Siel\AcumulusCustomiseInvoice\Helper\AcumulusCustomiseInvoice;

/**
 * Siel Acumulus invoice create after observer.
 */
class AcumulusInvoiceCreateAfter implements ObserverInterface
{
    private AcumulusCustomiseInvoice $handler;

    public function __construct(AcumulusCustomiseInvoice $acumulusEventHandler)
    {
        $this->handler = $acumulusEventHandler;
    }

    public function execute(EventObserver $observer): void
    {
        $this->handler->invoiceCreateAfter(
            $observer->getDataByKey('invoice'),
            $observer->getDataByKey('invoiceSource'),
            $observer->getDataByKey('localResult')
        );
    }
}
