<?php
namespace Siel\Acumulus;

/**
 * Plugin defines the version and other plugin related constants.
 *
 * These constants are mainly used as configuration settings.
 */
interface PluginConfig
{

    /**
     * @var string Version of this library, used in reporting.
     *   Note that composer will use git tags to determine the version of this
     *   library, this version is used in communication with the Acumulus API
     *   and when users contact support.
     */
    const Version = '6.0.4';

    /**
     * @var string Format to use with date() and DateTime formatting methods for
     *   SQL timestamps.
     */
    const TimeStampFormat_Sql = 'Y-m-d H:i:s';

    const Send_SendAndMailOnError = 1;
    const Send_SendAndMail = 2;
    const Send_TestMode = 3;

    // Not an API constant.
    const Concept_Plugin = 2;

    const MissingAmount_Ignore = 1;
    const MissingAmount_Warn = 2;
    const MissingAmount_AddLine = 3;

    const InvoiceNrSource_ShopInvoice = 1;
    const InvoiceNrSource_ShopOrder = 2;
    const InvoiceNrSource_Acumulus = 3;

    const InvoiceDate_InvoiceCreate = 1;
    const InvoiceDate_OrderCreate = 2;
    const InvoiceDate_Transfer = 3;

    const Nature_Unknown = 0;
    const Nature_Both = 1;
    const Nature_Products = 2;
    const Nature_Services = 3;

    const ForeignVat_Unknown = 0;
    const ForeignVat_Both = 1;
    const ForeignVat_No = 2;
    const ForeignVat_Only = 3;

    const VatFreeProducts_Unknown = 0;
    const VatFreeProducts_Both = 1;
    const VatFreeProducts_No = 2;
    const VatFreeProducts_Only = 3;

    const MarginProducts_Unknown = 0;
    const MarginProducts_Both = 1;
    const MarginProducts_No = 2;
    const MarginProducts_Only = 3;

    const TriggerInvoiceEvent_None = 0;
    const TriggerInvoiceEvent_Create = 1;
    const TriggerInvoiceEvent_Send = 2;

    const TriggerCreditNoteEvent_None = 0;
    const TriggerCreditNoteEvent_Create = 1;
}
