<?php
namespace Siel\Acumulus\Joomla\Shop;

use DateTimeZone;
use JDate;
use JEventDispatcher;
use JFactory;
use JPluginHelper;
use Siel\Acumulus\Invoice\Source as Source;
use Siel\Acumulus\Shop\InvoiceManager as BaseInvoiceManager;
use Siel\Acumulus\Invoice\Result;

/**
 * {@inheritdoc}
 *
 * This override provides Joomla specific db helper methods and defines
 * and dispatches Joomla events for the events defined by our library.
 */
abstract class InvoiceManager extends BaseInvoiceManager
{
    /**
     * Helper method that executes a query to retrieve a list of invoice source
     * ids and returns a list of invoice sources for these ids.
     *
     * @param string $invoiceSourceType
     * @param string $query
     *
     * @return \Siel\Acumulus\Invoice\Source[]
     *   A non keyed array with invoice Sources.
     */
    protected function getSourcesByQuery($invoiceSourceType, $query)
    {
        $sourceIds = $this->loadColumn($query);
        return $this->getSourcesByIdsOrSources($invoiceSourceType, $sourceIds);
    }

    /**
     * Helper method to execute a query and return the 1st column from the
     * results.
     *
     * @param string $query
     *
     * @return int[]
     *   A non keyed array with the values of the 1st results of the query result.
     */
    protected function loadColumn($query)
    {
        return $this->getDb()->setQuery($query)->loadColumn();
    }

    /**
     * Helper method to get the db object.
     *
     * @return \JDatabaseDriver
     */
    protected function getDb()
    {
        return JFactory::getDbo();
    }

	/**
	 * Helper method that returns a date in the correct and escaped sql format.
	 *
	 * @param string $date
	 *   Date in yyyy-mm-dd format.
	 *
	 * @return string
	 *
	 * @throws \Exception
	 */
    protected function toSql($date)
    {
        $tz = new DateTimeZone(JFactory::getApplication()->get('offset'));
        $date = new JDate($date);
        $date->setTimezone($tz);
        return $date->toSql(true);
    }

    /**
     * {@inheritdoc}
     *
     * This Joomla override dispatches the 'onAcumulusInvoiceCreated' event.
     */
    protected function triggerInvoiceCreated(array &$invoice, Source $invoiceSource, Result $localResult)
    {
        JPluginHelper::importPlugin('acumulus');
        $results = JEventDispatcher::getInstance()->trigger('onAcumulusInvoiceCreated', array(&$invoice, $invoiceSource, $localResult));
        if (count(array_filter($results, function ($value) {
                return $value === false;
            })) >= 1
        ) {
            $invoice = null;
        }
    }

    /**
     * {@inheritdoc}
     *
     * This Joomla override dispatches the 'onAcumulusInvoiceSendBefore' event.
     */
    protected function triggerInvoiceSendBefore(array &$invoice, Source $invoiceSource, Result $localResult)
    {
        JPluginHelper::importPlugin('acumulus');
        $results = JEventDispatcher::getInstance()->trigger('onAcumulusInvoiceSendBefore', array(&$invoice, $invoiceSource, $localResult));
        if (count(array_filter($results, function ($value) {
                return $value === false;
            })) >= 1
        ) {
            $invoice = null;
        }
    }

    /**
     * {@inheritdoc}
     *
     * This Joomla override dispatches the 'onAcumulusInvoiceSent' event.
     */
    protected function triggerInvoiceSendAfter(array $invoice, Source $invoiceSource, Result $result)
    {
        JPluginHelper::importPlugin('acumulus');
        JEventDispatcher::getInstance()->trigger('onAcumulusInvoiceSendAfter', array($invoice, $invoiceSource, $result));
    }
}
